import { ChainId, CHAIN_TO_ADDRESSES_MAP, SWAP_ROUTER_02_ADDRESSES as SWAP_ROUTER_02_ADDRESSES_HELPER, Token, WETH9 as WETH9_HELPER, } from '@uniswap/sdk-core';
import { FACTORY_ADDRESS } from '@uniswap/v3-sdk';
import { ADDRESS_ZERO } from '@uniswap/router-sdk';
import { NETWORKS_WITH_SAME_UNISWAP_ADDRESSES } from './chains';
export const BNB_TICK_LENS_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].tickLensAddress;
export const BNB_NONFUNGIBLE_POSITION_MANAGER_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].nonfungiblePositionManagerAddress;
export const BNB_SWAP_ROUTER_02_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].swapRouter02Address;
export const BNB_V3_MIGRATOR_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].v3MigratorAddress;
export const V3_CORE_FACTORY_ADDRESSES = {
    ...constructSameAddressMap(FACTORY_ADDRESS),
    [ChainId.CELO]: CHAIN_TO_ADDRESSES_MAP[ChainId.CELO].v3CoreFactoryAddress,
    [ChainId.CELO_ALFAJORES]: CHAIN_TO_ADDRESSES_MAP[ChainId.CELO_ALFAJORES].v3CoreFactoryAddress,
    [ChainId.OPTIMISM_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM_GOERLI].v3CoreFactoryAddress,
    [ChainId.OPTIMISM_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM_SEPOLIA].v3CoreFactoryAddress,
    [ChainId.SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.SEPOLIA].v3CoreFactoryAddress,
    [ChainId.ARBITRUM_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_GOERLI].v3CoreFactoryAddress,
    [ChainId.ARBITRUM_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_SEPOLIA].v3CoreFactoryAddress,
    [ChainId.BNB]: CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].v3CoreFactoryAddress,
    [ChainId.AVALANCHE]: CHAIN_TO_ADDRESSES_MAP[ChainId.AVALANCHE].v3CoreFactoryAddress,
    [ChainId.BASE_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_GOERLI].v3CoreFactoryAddress,
    [ChainId.BASE]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE].v3CoreFactoryAddress,
    [ChainId.BLAST]: CHAIN_TO_ADDRESSES_MAP[ChainId.BLAST].v3CoreFactoryAddress,
    [ChainId.ZORA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZORA].v3CoreFactoryAddress,
    [ChainId.ZKSYNC]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZKSYNC].v3CoreFactoryAddress,
    [ChainId.WORLDCHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.WORLDCHAIN].v3CoreFactoryAddress,
    [ChainId.UNICHAIN_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN_SEPOLIA].v3CoreFactoryAddress,
    [ChainId.MONAD_TESTNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MONAD_TESTNET].v3CoreFactoryAddress,
    [ChainId.BASE_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_SEPOLIA].v3CoreFactoryAddress,
    // TODO: Gnosis + Moonbeam contracts to be deployed
    [ChainId.UNICHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN].v3CoreFactoryAddress,
    [ChainId.SONEIUM]: CHAIN_TO_ADDRESSES_MAP[ChainId.SONEIUM].v3CoreFactoryAddress,
};
export const QUOTER_V2_ADDRESSES = {
    ...constructSameAddressMap('0x61fFE014bA17989E743c5F6cB21bF9697530B21e'),
    [ChainId.CELO]: CHAIN_TO_ADDRESSES_MAP[ChainId.CELO].quoterAddress,
    [ChainId.CELO_ALFAJORES]: CHAIN_TO_ADDRESSES_MAP[ChainId.CELO_ALFAJORES].quoterAddress,
    [ChainId.OPTIMISM_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM_GOERLI].quoterAddress,
    [ChainId.OPTIMISM_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM_SEPOLIA].quoterAddress,
    [ChainId.SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.SEPOLIA].quoterAddress,
    [ChainId.ARBITRUM_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_GOERLI].quoterAddress,
    [ChainId.ARBITRUM_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_SEPOLIA].quoterAddress,
    [ChainId.BNB]: CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].quoterAddress,
    [ChainId.AVALANCHE]: CHAIN_TO_ADDRESSES_MAP[ChainId.AVALANCHE].quoterAddress,
    [ChainId.BASE_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_GOERLI].quoterAddress,
    [ChainId.BASE]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE].quoterAddress,
    [ChainId.BLAST]: CHAIN_TO_ADDRESSES_MAP[ChainId.BLAST].quoterAddress,
    [ChainId.ZORA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZORA].quoterAddress,
    [ChainId.ZKSYNC]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZKSYNC].quoterAddress,
    [ChainId.WORLDCHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.WORLDCHAIN].quoterAddress,
    [ChainId.UNICHAIN_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN_SEPOLIA].quoterAddress,
    [ChainId.MONAD_TESTNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MONAD_TESTNET].quoterAddress,
    [ChainId.BASE_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_SEPOLIA].quoterAddress,
    // TODO: Gnosis + Moonbeam contracts to be deployed
    [ChainId.UNICHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN].quoterAddress,
    [ChainId.SONEIUM]: CHAIN_TO_ADDRESSES_MAP[ChainId.SONEIUM].quoterAddress,
};
export const NEW_QUOTER_V2_ADDRESSES = {
    ...constructSameAddressMap('0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3'),
    [ChainId.CELO]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3',
    [ChainId.CELO_ALFAJORES]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3',
    [ChainId.OPTIMISM_SEPOLIA]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3',
    [ChainId.SEPOLIA]: '0xf0c802dcb0cf1c4f7b953756b49d940eed190221',
    [ChainId.ARBITRUM_SEPOLIA]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3',
    [ChainId.BNB]: '0x5e55C9e631FAE526cd4B0526C4818D6e0a9eF0e3',
    [ChainId.AVALANCHE]: '0xf0c802dcb0cf1c4f7b953756b49d940eed190221',
    [ChainId.POLYGON_MUMBAI]: '0x60e06b92bC94a665036C26feC5FF2A92E2d04c5f',
    [ChainId.BASE]: '0x222cA98F00eD15B1faE10B61c277703a194cf5d2',
    [ChainId.BLAST]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [ChainId.ZORA]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [ChainId.ZKSYNC]: '0x071Bd2063dF031EDd110E27C6F4CDe50A3DeF2d4',
    [ChainId.WORLDCHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.WORLDCHAIN].quoterAddress,
    [ChainId.UNICHAIN_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN_SEPOLIA].quoterAddress,
    [ChainId.MONAD_TESTNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MONAD_TESTNET].quoterAddress,
    [ChainId.BASE_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_SEPOLIA].quoterAddress,
    [ChainId.UNICHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN].quoterAddress,
    [ChainId.SONEIUM]: CHAIN_TO_ADDRESSES_MAP[ChainId.SONEIUM].quoterAddress,
};
export const PROTOCOL_V4_QUOTER_ADDRESSES = {
    ...constructSameAddressMap('0xf3a39c86dbd13c45365e57fb90fe413371f65af8'),
    [ChainId.SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.SEPOLIA].v4QuoterAddress,
    [ChainId.ARBITRUM_ONE]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_ONE].v4QuoterAddress,
    [ChainId.BASE]: '0xe1a6c5803e3c44368b171bd680c7d32dfc92ca47',
    [ChainId.POLYGON]: CHAIN_TO_ADDRESSES_MAP[ChainId.POLYGON].v4QuoterAddress,
    [ChainId.BNB]: CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].v4QuoterAddress,
    [ChainId.AVALANCHE]: CHAIN_TO_ADDRESSES_MAP[ChainId.AVALANCHE].v4QuoterAddress,
    [ChainId.OPTIMISM]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM].v4QuoterAddress,
    [ChainId.WORLDCHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.WORLDCHAIN].v4QuoterAddress,
    [ChainId.ZORA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZORA].v4QuoterAddress,
    [ChainId.UNICHAIN_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN_SEPOLIA].v4QuoterAddress,
    [ChainId.UNICHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN].v4QuoterAddress,
    [ChainId.BLAST]: CHAIN_TO_ADDRESSES_MAP[ChainId.BLAST].v4QuoterAddress,
    [ChainId.MAINNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MAINNET].v4QuoterAddress,
    [ChainId.SONEIUM]: CHAIN_TO_ADDRESSES_MAP[ChainId.SONEIUM].v4QuoterAddress,
};
export const MIXED_ROUTE_QUOTER_V1_ADDRESSES = {
    [ChainId.MAINNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MAINNET].mixedRouteQuoterV1Address,
    [ChainId.GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.GOERLI].mixedRouteQuoterV1Address,
    [ChainId.BASE]: '0xe544efae946f0008ae9a8d64493efa7886b73776',
    [ChainId.UNICHAIN]: '0x48C0648E357639B446C99a6c7316A3eaFEaB35aE',
    [ChainId.ARBITRUM_ONE]: '0x003aa18c6E682dB80Cf4aa17261CcbFfd28690CE',
    [ChainId.POLYGON]: '0x58ead433EA99708604C4dD7c9b7E80C70976E202',
    [ChainId.OPTIMISM]: '0x204faca1764b154221e35c0d20abb3c525710498',
    [ChainId.AVALANCHE]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [ChainId.BNB]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [ChainId.WORLDCHAIN]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [ChainId.ZORA]: '0x204FAca1764B154221e35c0d20aBb3c525710498',
    [ChainId.SONEIUM]: '0x42c14CE921e85bf14467A82fAf8182546cf7c604',
};
export const MIXED_ROUTE_QUOTER_V2_ADDRESSES = {
    [ChainId.SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.SEPOLIA].mixedRouteQuoterV2Address,
    [ChainId.MAINNET]: '0xE63C5F5005909E96b5aA9CE10744CCE70eC16CC3',
    [ChainId.BASE]: '0x253ee8eb6551b47181b613461c15d699fe4a2e39',
    [ChainId.UNICHAIN]: '0x48C0648E357639B446C99a6c7316A3eaFEaB35aE',
    [ChainId.ARBITRUM_ONE]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [ChainId.POLYGON]: '0x9d0f15f2cf58655fddcd1ee6129c547fdaed01b1',
    [ChainId.OPTIMISM]: '0xf0c802DCb0cF1C4f7B953756b49D940EED190221',
    [ChainId.AVALANCHE]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [ChainId.BNB]: '0xf0c802DCb0cF1C4f7B953756b49D940EED190221',
    [ChainId.WORLDCHAIN]: '0x9D0F15f2cf58655fDDcD1EE6129C547fDaeD01b1',
    [ChainId.ZORA]: '0x5f739c790a48E97eec0efb81bab5D152c0A0ecA0',
    [ChainId.SONEIUM]: '0x42c14CE921e85bf14467A82fAf8182546cf7c604',
};
export const UNISWAP_MULTICALL_ADDRESSES = {
    ...constructSameAddressMap('0x1F98415757620B543A52E61c46B32eB19261F984'),
    [ChainId.CELO]: CHAIN_TO_ADDRESSES_MAP[ChainId.CELO].multicallAddress,
    [ChainId.CELO_ALFAJORES]: CHAIN_TO_ADDRESSES_MAP[ChainId.CELO_ALFAJORES].multicallAddress,
    [ChainId.OPTIMISM_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM_GOERLI].multicallAddress,
    [ChainId.OPTIMISM_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM_SEPOLIA].multicallAddress,
    [ChainId.SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.SEPOLIA].multicallAddress,
    [ChainId.ARBITRUM_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_GOERLI].multicallAddress,
    [ChainId.ARBITRUM_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_SEPOLIA].multicallAddress,
    [ChainId.BNB]: CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].multicallAddress,
    [ChainId.AVALANCHE]: CHAIN_TO_ADDRESSES_MAP[ChainId.AVALANCHE].multicallAddress,
    [ChainId.BASE_GOERLI]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_GOERLI].multicallAddress,
    [ChainId.BASE]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE].multicallAddress,
    [ChainId.BLAST]: CHAIN_TO_ADDRESSES_MAP[ChainId.BLAST].multicallAddress,
    [ChainId.ZORA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZORA].multicallAddress,
    [ChainId.ZKSYNC]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZKSYNC].multicallAddress,
    [ChainId.WORLDCHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.WORLDCHAIN].multicallAddress,
    [ChainId.UNICHAIN_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN_SEPOLIA].multicallAddress,
    [ChainId.MONAD_TESTNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MONAD_TESTNET].multicallAddress,
    [ChainId.BASE_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE_SEPOLIA].multicallAddress,
    // TODO: Gnosis + Moonbeam contracts to be deployed
    [ChainId.UNICHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN].multicallAddress,
    [ChainId.SONEIUM]: CHAIN_TO_ADDRESSES_MAP[ChainId.SONEIUM].multicallAddress,
};
export const SWAP_ROUTER_02_ADDRESSES = (chainId) => {
    var _a;
    return ((_a = SWAP_ROUTER_02_ADDRESSES_HELPER(chainId)) !== null && _a !== void 0 ? _a : '0x68b3465833fb72A70ecDF485E0e4C7bD8665Fc45');
};
export const STATE_VIEW_ADDRESSES = {
    ...constructSameAddressMap('0x1F98415757620B543A52E61c46B32eB19261F984'),
    [ChainId.SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.SEPOLIA].v4StateView,
    [ChainId.ARBITRUM_ONE]: CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_ONE].v4StateView,
    [ChainId.BASE]: CHAIN_TO_ADDRESSES_MAP[ChainId.BASE].v4StateView,
    [ChainId.POLYGON]: CHAIN_TO_ADDRESSES_MAP[ChainId.POLYGON].v4StateView,
    [ChainId.BNB]: CHAIN_TO_ADDRESSES_MAP[ChainId.BNB].v4StateView,
    [ChainId.OPTIMISM]: CHAIN_TO_ADDRESSES_MAP[ChainId.OPTIMISM].v4StateView,
    [ChainId.AVALANCHE]: CHAIN_TO_ADDRESSES_MAP[ChainId.AVALANCHE].v4StateView,
    [ChainId.WORLDCHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.WORLDCHAIN].v4StateView,
    [ChainId.ZORA]: CHAIN_TO_ADDRESSES_MAP[ChainId.ZORA].v4StateView,
    [ChainId.UNICHAIN_SEPOLIA]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN_SEPOLIA].v4StateView,
    [ChainId.UNICHAIN]: CHAIN_TO_ADDRESSES_MAP[ChainId.UNICHAIN].v4StateView,
    [ChainId.BLAST]: CHAIN_TO_ADDRESSES_MAP[ChainId.BLAST].v4StateView,
    [ChainId.MAINNET]: CHAIN_TO_ADDRESSES_MAP[ChainId.MAINNET].v4StateView,
    [ChainId.SONEIUM]: CHAIN_TO_ADDRESSES_MAP[ChainId.SONEIUM].v4StateView,
};
export const OVM_GASPRICE_ADDRESS = '0x420000000000000000000000000000000000000F';
export const ARB_GASINFO_ADDRESS = '0x000000000000000000000000000000000000006C';
export const TICK_LENS_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.ARBITRUM_ONE].tickLensAddress;
export const NONFUNGIBLE_POSITION_MANAGER_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.MAINNET].nonfungiblePositionManagerAddress;
export const V3_MIGRATOR_ADDRESS = CHAIN_TO_ADDRESSES_MAP[ChainId.MAINNET].v3MigratorAddress;
export const MULTICALL2_ADDRESS = '0x5BA1e12693Dc8F9c48aAD8770482f4739bEeD696';
export function constructSameAddressMap(address, additionalNetworks = []) {
    return NETWORKS_WITH_SAME_UNISWAP_ADDRESSES.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = address;
        return memo;
    }, {});
}
export const WETH9 = {
    [ChainId.MAINNET]: WETH9_HELPER[ChainId.MAINNET],
    [ChainId.GOERLI]: WETH9_HELPER[ChainId.GOERLI],
    [ChainId.SEPOLIA]: WETH9_HELPER[ChainId.SEPOLIA],
    [ChainId.OPTIMISM]: WETH9_HELPER[ChainId.OPTIMISM],
    [ChainId.OPTIMISM_GOERLI]: new Token(ChainId.OPTIMISM_GOERLI, '0x4200000000000000000000000000000000000006', 18, 'WETH', 'Wrapped Ether'),
    [ChainId.OPTIMISM_SEPOLIA]: WETH9_HELPER[ChainId.OPTIMISM_SEPOLIA],
    [ChainId.ARBITRUM_ONE]: WETH9_HELPER[ChainId.ARBITRUM_ONE],
    [ChainId.ARBITRUM_GOERLI]: new Token(ChainId.ARBITRUM_GOERLI, '0xe39Ab88f8A4777030A534146A9Ca3B52bd5D43A3', 18, 'WETH', 'Wrapped Ether'),
    [ChainId.ARBITRUM_SEPOLIA]: WETH9_HELPER[ChainId.ARBITRUM_SEPOLIA],
    [ChainId.BASE_GOERLI]: new Token(ChainId.BASE_GOERLI, '0x4200000000000000000000000000000000000006', 18, 'WETH', 'Wrapped Ether'),
    [ChainId.BASE]: WETH9_HELPER[ChainId.BASE],
    [ChainId.BLAST]: WETH9_HELPER[ChainId.BLAST],
    [ChainId.ZORA]: WETH9_HELPER[ChainId.ZORA],
    [ChainId.ZORA_SEPOLIA]: new Token(ChainId.ZORA_SEPOLIA, '0x4200000000000000000000000000000000000006', 18, 'WETH', 'Wrapped Ether'),
    [ChainId.ZKSYNC]: WETH9_HELPER[ChainId.ZKSYNC],
    [ChainId.WORLDCHAIN]: WETH9_HELPER[ChainId.WORLDCHAIN],
    [ChainId.UNICHAIN_SEPOLIA]: WETH9_HELPER[ChainId.UNICHAIN_SEPOLIA],
    [ChainId.BASE_SEPOLIA]: WETH9_HELPER[ChainId.BASE_SEPOLIA],
    [ChainId.UNICHAIN]: WETH9_HELPER[ChainId.UNICHAIN],
    [ChainId.SONEIUM]: WETH9_HELPER[ChainId.SONEIUM],
};
export const BEACON_CHAIN_DEPOSIT_ADDRESS = '0x00000000219ab540356cBB839Cbe05303d7705Fa';
export function getAddressLowerCase(currency) {
    if (currency.isToken) {
        return currency.address.toLowerCase();
    }
    else {
        return ADDRESS_ZERO;
    }
}
export function getAddress(currency) {
    if (currency.isToken) {
        return currency.address;
    }
    else {
        return ADDRESS_ZERO;
    }
}
//# sourceMappingURL=data:application/json;base64,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